import turtle
turtle.tracer(10, 0) # Zwiększ wartość pierwszego argumentu, aby przyspieszyć rysowanie
turtle.setworldcoordinates(0, 0, 700, 700)
turtle.hideturtle()

MIN_SIZE = 6 # Zmodyfikuj ten parametr, aby zwiększyć/zmniejszyć liczbę wywołań rekurencyjnych
DRAW_SOLID = True

def isTooSmall(width, height):
    # Sprawdzenie, czy trójkąt nie jest zbyt mały, aby dało się go narysować
    return width < MIN_SIZE or height < MIN_SIZE

def drawCarpet(x, y, width, height):
    # Współrzędne x i y reprezentują lewy dolny róg dywanu

    # Przesunięcie pióra na pozycję
    turtle.penup()
    turtle.goto(x, y)

    # Rysowanie zewnętrznego trójkąta
    turtle.pendown()
    if DRAW_SOLID:
        turtle.fillcolor('black')
        turtle.begin_fill()
    turtle.goto(x, y + height)
    turtle.goto(x + width, y + height)
    turtle.goto(x + width, y)
    turtle.goto(x, y)
    if DRAW_SOLID:
        turtle.end_fill()
    turtle.penup()

    # Rysowanie wewnętrznego trójkata
    drawInnerRectangle(x, y, width, height)

def drawInnerRectangle(x, y, width, height):
    if isTooSmall(width, height):
        # PRZYPADEK BAZOWY
        return
    else:
        # PRZYPADEK REKURENCYJNY

        oneThirdWidth = width / 3
        oneThirdHeight = height / 3
        twoThirdsWidth = 2 * (width / 3)
        twoThirdsHeight = 2 * (height / 3)

        # Przesunięcie żółwia na pozycję
        turtle.penup()
        turtle.goto(x + oneThirdWidth, y + oneThirdHeight)

        # Rysowanie wewnętrznego prostokąta
        if DRAW_SOLID:
            turtle.fillcolor('white')
            turtle.begin_fill()
        turtle.pendown()
        turtle.goto(x + oneThirdWidth, y + twoThirdsHeight)
        turtle.goto(x + twoThirdsWidth, y + twoThirdsHeight)
        turtle.goto(x + twoThirdsWidth, y + oneThirdHeight)
        turtle.goto(x + oneThirdWidth, y + oneThirdHeight)
        turtle.penup()
        if DRAW_SOLID:
            turtle.end_fill()

        # Rysowanie wewnętrznych prostokątów u góry dywanu
        drawInnerRectangle(x, y + twoThirdsHeight, oneThirdWidth, oneThirdHeight)
        drawInnerRectangle(x + oneThirdWidth, y + twoThirdsHeight, oneThirdWidth,
        oneThirdHeight)
        drawInnerRectangle(x + twoThirdsWidth, y + twoThirdsHeight, oneThirdWidth,
        oneThirdHeight)

        # Rysowanie wewnętrznych prostokątów w środku dywanu
        drawInnerRectangle(x, y + oneThirdHeight, oneThirdWidth, oneThirdHeight)
        drawInnerRectangle(x + twoThirdsWidth, y + oneThirdHeight, oneThirdWidth,
        oneThirdHeight)

        # Rysowanie wewnętrznych prostokątów na dole dywanu
        drawInnerRectangle(x, y, oneThirdWidth, oneThirdHeight)
        drawInnerRectangle(x + oneThirdWidth, y, oneThirdWidth, oneThirdHeight)
        drawInnerRectangle(x + twoThirdsWidth, y, oneThirdWidth, oneThirdHeight)

drawCarpet(50, 50, 600, 600)
turtle.exitonclick()
